﻿var NUM_COLUMNS = 4;
var g_RowCount = 0;
var g_OffSet = 0;

var card_index;
var gbe_index;
var colWidth = new Array("80px","80px","80px","80px");

function AddRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(g_RowCount + 1);

		for(var j = 0; j < NUM_COLUMNS; j++)
		{
			var cell = row.insertCell(j);
		}
		
		g_RowCount++;
	}
}

function UpdateRowNum(tableId, dataLen)
{
	g_OffSet = g_RowCount;
	AddRows(tableId, (dataLen - 1));
}

function UpdateRowData(table, rowID, rowData)
{
	var row = rowID + g_OffSet;
	
	for(var i = 0; i < NUM_COLUMNS; i++)
	{
		var textData = "";
		var cell = table.rows[row].cells[i];
		cell.style.width = colWidth[i];
		
		if(i == 0)
		{
			textData = rowData[i];			
		}
		else
		{
			textData = parseFloat(rowData[i]).toFixed(4);
		}
		cell.innerHTML = textData;
	}
}

function UpdateTableData(tableId, inpResp)
{
	var dataLen = inpResp.length;
	var MeasRow = new Array(NUM_COLUMNS);
	var table = document.getElementById(tableId);
	for(var i = 0;i < (dataLen - 1); i++)
	{
		MeasRow = inpResp[i];
		var rowData = MeasRow.split(",");
		UpdateRowData(table, (i + 1), rowData);
	}
}

function PaintMeasTable(MeasTable)
{
	var dataLen = MeasTable.length;//the end is row value, then dataLen is n+1
	UpdateRowNum("MeasInpTable",dataLen);
	UpdateTableData("MeasInpTable",MeasTable);
	return true;
}

var gbe_port;
var init_row = true;
function GetMeasureInpData()
{
	var xmlhttp = false;
	xmlhttp = getHTTPObject();

	if(init_row)
	{
		gbe_port = card_index + "/" + "1";
	}
	
	var params = "type=10&cmd=1&gbe_port=" + gbe_port;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var Response = xmlhttp.responseText;
			var inpResp = Response.slice(7, -8).split("&");
			var inpLen = inpResp.length;
			PaintMeasTable(inpResp);

			init_row = false;
			
			if(inpResp[inpLen - 1].indexOf("gbe_port") != -1)
			{
				var cur_row_string = inpResp[inpLen - 1].split(",");
				gbe_port = cur_row_string[1];
			}

			if(inpResp[inpLen - 1] == "end")
			{
				init_row = true;
				return true;
			}
			setTimeout("GetMeasureInpData()", 5);
		}
	}
	xmlhttp.send(params);
}

/***** functions called on load of page *****/
window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	GetMeasureInpData();
}

